/****** Object:  StoredProcedure [CRS].[usp_STD_REFERRALSTS_getitemByCode]    Script Date: 1/30/2018 4:43:02 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_REFERRALSTS_getitemByCode]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_STD_REFERRALSTS_getitemByCode]
GO

/****** Object:  StoredProcedure [CRS].[usp_STD_REFERRALSTS_getitemByCode]    Script Date: 1/30/2018 4:43:02 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_REFERRALSTS_getitemByCode]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:        
-- Create date:   05/21/2016
-- Description:   Get record by ID
-- =============================================
CREATE PROCEDURE [CRS].[usp_STD_REFERRALSTS_getitemByCode] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @CODE varchar(50))
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_STD_REFERRALSTS_getitemByCode'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	--GET REFERRAL STATUS ID
	IF EXISTS(SELECT [ID] FROM [CRS].[STD_REFERRALSTS] WHERE [STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID AND [CODE] = @CODE)
		SELECT * FROM [CRS].[STD_REFERRALSTS] WHERE [STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID AND [CODE] = @CODE;
	ELSE
		SELECT [CRS].[STD_REFERRALSTS].* FROM [CRS].[STD_REFERRALSTS] 
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [STD_REGISTRY_ID] AND [CRS].[STD_REGISTRY].[CODE] = ''CRS''
		WHERE [CRS].[STD_REFERRALSTS].[CODE] = @CODE;
END
' 
END
GO



/****** Object:  StoredProcedure [CRS].[usp_PATIENT_getitem]    Script Date: 2/5/2018 3:24:19 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATIENT_getitem]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PATIENT_getitem]
GO

/****** Object:  StoredProcedure [CRS].[usp_PATIENT_getitem]    Script Date: 2/5/2018 3:24:19 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATIENT_getitem]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'







-- =============================================
-- Author:        
-- Create date:   12/15/2015
-- Description:   Get record by ID
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATIENT_getitem] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @PATIENT_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_PATIENT_getitem'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT 
		[PATIENT_ID]
		,[FIRST_NAME]
		,[MIDDLE_NAME]
		,[LAST_NAME]
		,[EMAIL_ADDRESS]
		,[BIRTH_DATE]
		,[DEATH_DATE]
		,[CELL_PHONE]
		,[PERFERRED_ADDRESS_TYPE]
		,[CREATEDBY]
		,[CREATED]
		,[UPDATEDBY]
		,[UPDATED]
		,[OEFOIF_IND]
		,[PATIENTSID]
		,[PatientICN] 
		,(CASE (SELECT COUNT(PatientRaceSID) FROM [CRS].[PATSUB_PATIENTRACE] WHERE [CRS].[PATSUB_PATIENTRACE].[PatientSID] = [CRS].[PATIENT].[PATIENTSID])
			WHEN 0 THEN CONVERT(bit, 0)
			WHEN 1 THEN CONVERT(bit, 0)
			ELSE CONVERT(bit, 1)
		END) AS [MULTI_RACE_INDICATOR]
		,(CASE (SELECT COUNT(PatientEthnicitySID) FROM [CRS].[PATIENT_ETHNICITY] WHERE [CRS].[PATIENT_ETHNICITY].[PatientSID] = [CRS].[PATIENT].[PATIENTSID])
			WHEN 0 THEN CONVERT(bit, 0)
			WHEN 1 THEN CONVERT(bit, 0)
			ELSE CONVERT(bit, 1)
		END) AS [MULTI_ETHNICITY_INDICATOR]
	  FROM [CRS].[PATIENT] WHERE [PATIENT_ID] = @PATIENT_ID;
END

' 
END
GO



/****** Object:  StoredProcedure [CRS].[usp_PATIENT_getitemComplete]    Script Date: 2/5/2018 3:31:33 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATIENT_getitemComplete]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PATIENT_getitemComplete]
GO

/****** Object:  StoredProcedure [CRS].[usp_PATIENT_getitemComplete]    Script Date: 2/5/2018 3:31:33 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATIENT_getitemComplete]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/15/2015
-- Description:   Get record by ID
---               Updated Stored Procedure to Display either Zip or PostalCode from SPATIENT table.
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATIENT_getitemComplete] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @PATIENT_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_PATIENT_getitemComplete'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE]
		,[CRS].[PATIENT].[CELL_PHONE] AS [PATIENT_CELL_PHONE]
		,[CRS].[PATIENT].[CREATED] AS [PATIENT_CREATED]
		,[CRS].[PATIENT].[CREATEDBY] AS [PATIENT_CREATEDBY]
		,[CRS].[PATIENT].[DEATH_DATE] AS [PATIENT_DEATH_DATE]
		,[CRS].[PATIENT].[EMAIL_ADDRESS] AS [PATIENT_EMAIL_ADDRESS]
		,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME]
		,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME]
		,[CRS].[PATIENT].[MIDDLE_NAME] AS [PATIENT_MIDDLE_NAME]
		,[CRS].[PATIENT].[OEFOIF_IND] AS [PATIENT_OEFOIF_IND]
		,[CRS].[PATIENT].[PATIENT_ID] AS [PATIENT_PATIENT_ID]
		,[CRS].[PATIENT].[PATIENTSID] AS [PATIENT_PATIENTSID]
		,[CRS].[PATIENT].[PERFERRED_ADDRESS_TYPE] AS [PATIENT_PERFERRED_ADDRESS_TYPE]
		,[CRS].[PATIENT].[UPDATED] AS [PATIENT_UPDATED]
		,[CRS].[PATIENT].[UPDATEDBY] AS [PATIENT_UPDATEDBY]
		,[CRS].[PATIENT].[PatientICN] AS [PATIENT_PatientICN]
		,(CASE (SELECT COUNT(PatientRaceSID) FROM [CRS].[PATSUB_PATIENTRACE] WHERE [CRS].[PATSUB_PATIENTRACE].[PatientSID] = [CRS].[PATIENT].[PATIENTSID])
			WHEN 0 THEN CONVERT(bit, 0)
			WHEN 1 THEN CONVERT(bit, 0)
			ELSE CONVERT(bit, 1)
		END) AS [MULTI_RACE_INDICATOR]
		,(CASE (SELECT COUNT(PatientEthnicitySID) FROM [CRS].[PATIENT_ETHNICITY] WHERE [CRS].[PATIENT_ETHNICITY].[PatientSID] = [CRS].[PATIENT].[PATIENTSID])
			WHEN 0 THEN CONVERT(bit, 0)
			WHEN 1 THEN CONVERT(bit, 0)
			ELSE CONVERT(bit, 1)
		END) AS [MULTI_ETHNICITY_INDICATOR]

		,[CRS].[SPATIENT].[AddressChangeInstitutionIEN] AS [SPATIENT_AddressChangeInstitutionIEN]
		,[CRS].[SPATIENT].[AddressChangeInstitutionSID] AS [SPATIENT_AddressChangeInstitutionSID]
		,[CRS].[SPATIENT].[AddressChangeStaffIEN] AS [SPATIENT_AddressChangeStaffIEN]
		,[CRS].[SPATIENT].[AddressChangeStaffSID] AS [SPATIENT_AddressChangeStaffSID]
		,[CRS].[SPATIENT].[Age] AS [SPATIENT_Age]
		,[CRS].[SPATIENT].[BadAddressIndicator] AS [SPATIENT_BadAddressIndicator]
		,[CRS].[SPATIENT].[CDDeterminingInstitutionIEN] AS [SPATIENT_CDDeterminingInstitutionIEN]
		,[CRS].[SPATIENT].[City] AS [SPATIENT_City]
		,[CRS].[SPATIENT].[CombatFromVistaDate] AS [SPATIENT_CombatFromVistaDate]
		,[CRS].[SPATIENT].[CombatToVistaDate] AS [SPATIENT_CombatToVistaDate]
		,[CRS].[SPATIENT].[ConfidentialAddressActiveFlag] AS [SPATIENT_ConfidentialAddressActiveFlag]
		,[CRS].[SPATIENT].[Country] AS [SPATIENT_Country]
		,[CRS].[SPATIENT].[CountryIEN] AS [SPATIENT_CountryIEN]
		,[CRS].[SPATIENT].[CountrySID] AS [SPATIENT_CountrySID]
		,[CRS].[SPATIENT].[County] AS [SPATIENT_County]
		,[CRS].[SPATIENT].[Created] AS [SPATIENT_Created]
		,[CRS].[SPATIENT].[CreatedBy] AS [SPATIENT_CreatedBy]
		,[CRS].[SPATIENT].[CurrentMeansTestStatusIEN] AS [SPATIENT_CurrentMeansTestStatusIEN]
		,[CRS].[SPATIENT].[DateOfBirth] AS [SPATIENT_DateOfBirth]
		,[CRS].[SPATIENT].[DateOfBirthText] AS [SPATIENT_DateOfBirthText]
		,[CRS].[SPATIENT].[DateOfDeath] AS [SPATIENT_DateOfDeath]
		,[CRS].[SPATIENT].[DateOfDeathText] AS [SPATIENT_DateOfDeathText]
		,[CRS].[SPATIENT].[Deceased] AS [SPATIENT_Deceased]
		,[CRS].[SPATIENT].[DEFAULT_RECORD] AS [SPATIENT_DEFAULT_RECORD]
		,[CRS].[SPATIENT].[Eligibility] AS [SPATIENT_Eligibility]
		,[CRS].[SPATIENT].[EligibilityIEN] AS [SPATIENT_EligibilityIEN]
		,[CRS].[SPATIENT].[EligibilitySID] AS [SPATIENT_EligibilitySID]
		,[CRS].[SPATIENT].[EligibilityStatus] AS [SPATIENT_EligibilityStatus]
		,[CRS].[SPATIENT].[EligibilityVACode] AS [SPATIENT_EligibilityVACode]
		,[CRS].[SPATIENT].[EligibilityVerificationSource] AS [SPATIENT_EligibilityVerificationSource]
		,[CRS].[SPATIENT].[EmailAddress] AS [SPATIENT_EmailAddress]
		,[CRS].[SPATIENT].[EnteredIntoFileDate] AS [SPATIENT_EnteredIntoFileDate]
		,[CRS].[SPATIENT].[EnteredIntoFileDateTransformSID] AS [SPATIENT_EnteredIntoFileDateTransformSID]
		,[CRS].[SPATIENT].[EnteredIntoFileVistaErrorDate] AS [SPATIENT_EnteredIntoFileVistaErrorDate]
		,[CRS].[SPATIENT].[ETLBatchID] AS [SPATIENT_ETLBatchID]
		,[CRS].[SPATIENT].[ExcludeFromFacilityDirectoryFlag] AS [SPATIENT_ExcludeFromFacilityDirectoryFlag]
		,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender]
		,[CRS].[SPATIENT].[GISAddressType] AS [SPATIENT_GISAddressType]
		,[CRS].[SPATIENT].[GISAddressUpdatedDate] AS [SPATIENT_GISAddressUpdatedDate]
		,[CRS].[SPATIENT].[GISCongressDistrict] AS [SPATIENT_GISCongressDistrict]
		,[CRS].[SPATIENT].[GISFIPSCode] AS [SPATIENT_GISFIPSCode]
		,[CRS].[SPATIENT].[GISLocatorName] AS [SPATIENT_GISLocatorName]
		,[CRS].[SPATIENT].[GISMarket] AS [SPATIENT_GISMarket]
		,[CRS].[SPATIENT].[GISMatchedAddress] AS [SPATIENT_GISMatchedAddress]
		,[CRS].[SPATIENT].[GISMatchMethodCode] AS [SPATIENT_GISMatchMethodCode]
		,[CRS].[SPATIENT].[GISMatchScore] AS [SPATIENT_GISMatchScore]
		,[CRS].[SPATIENT].[GISMatchStatusCode] AS [SPATIENT_GISMatchStatusCode]
		,[CRS].[SPATIENT].[GISPatientAddressLatitude] AS [SPATIENT_GISPatientAddressLatitude]
		,[CRS].[SPATIENT].[GISPatientAddressLongitude] AS [SPATIENT_GISPatientAddressLongitude]
		,[CRS].[SPATIENT].[GISSector] AS [SPATIENT_GISSector]
		,[CRS].[SPATIENT].[GISStreetSide] AS [SPATIENT_GISStreetSide]
		,[CRS].[SPATIENT].[GISSubmarket] AS [SPATIENT_GISSubmarket]
		,[CRS].[SPATIENT].[GISURH] AS [SPATIENT_GISURH]
		,[CRS].[SPATIENT].[InsuranceCoverageFlag] AS [SPATIENT_InsuranceCoverageFlag]
		,[CRS].[SPATIENT].[LastServiceEntryDate] AS [SPATIENT_LastServiceEntryDate]
		,[CRS].[SPATIENT].[LastServiceEntryDateTransformSID] AS [SPATIENT_LastServiceEntryDateTransformSID]
		,[CRS].[SPATIENT].[LastServiceEntryVistaErrorDate] AS [SPATIENT_LastServiceEntryVistaErrorDate]
		,[CRS].[SPATIENT].[LastServiceSeparationDate] AS [SPATIENT_LastServiceSeparationDate]
		,[CRS].[SPATIENT].[LastServiceSeparationDateTransformSID] AS [SPATIENT_LastServiceSeparationDateTransformSID]
		,[CRS].[SPATIENT].[LastServiceSeparationVistaErrorDate] AS [SPATIENT_LastServiceSeparationVistaErrorDate]
		,[CRS].[SPATIENT].[MaritalStatus] AS [SPATIENT_MaritalStatus]
		,[CRS].[SPATIENT].[MaritalStatusIEN] AS [SPATIENT_MaritalStatusIEN]
		,[CRS].[SPATIENT].[MaritalStatusSID] AS [SPATIENT_MaritalStatusSID]
		,[CRS].[SPATIENT].[MedicaidNumber] AS [SPATIENT_MedicaidNumber]
		,[CRS].[SPATIENT].[MothersMaidenName] AS [SPATIENT_MothersMaidenName]
		,[CRS].[SPATIENT].[OEF_OIF_IND] AS [SPATIENT_OEF_OIF_IND]
		,[CRS].[SPATIENT].[OpCode] AS [SPATIENT_OpCode]
		,[CRS].[SPATIENT].[Patient_ID] AS [SPATIENT_Patient_ID]
		,[CRS].[SPATIENT].[PatientFirstName] AS [SPATIENT_PatientFirstName]
		,[CRS].[SPATIENT].[PatientICN] AS [SPATIENT_PatientICN]
		,[CRS].[SPATIENT].[PatientICNChecksum] AS [SPATIENT_PatientICNChecksum]
		,[CRS].[SPATIENT].[PatientIEN] AS [SPATIENT_PatientIEN]
		,[CRS].[SPATIENT].[PatientLastName] AS [SPATIENT_PatientLastName]
		,[CRS].[SPATIENT].[PatientName] AS [SPATIENT_PatientName]
		,[CRS].[SPATIENT].[PatientSID] AS [SPATIENT_PatientSID]
		,[CRS].[SPATIENT].[PatientSSN] AS [SPATIENT_PatientSSN]
		,[CRS].[SPATIENT].[PercentServiceConnect] AS [SPATIENT_PercentServiceConnect]
		,[CRS].[SPATIENT].[PeriodOfService] AS [SPATIENT_PeriodOfService]
		,[CRS].[SPATIENT].[PeriodOfServiceIEN] AS [SPATIENT_PeriodOfServiceIEN]
		,[CRS].[SPATIENT].[PeriodOfServiceSID] AS [SPATIENT_PeriodOfServiceSID]
		,[CRS].[SPATIENT].[PhoneCellular] AS [SPATIENT_PhoneCellular]
		,[CRS].[SPATIENT].[PhoneResidence] AS [SPATIENT_PhoneResidence]
		,[CRS].[SPATIENT].[PhoneWork] AS [SPATIENT_PhoneWork]
		,[CRS].[SPATIENT].[PK_ID] AS [SPATIENT_PK_ID]
		,ISNULL([CRS].[SPATIENT].[PostalCode],[CRS].[SPATIENT].[Zip]) AS [SPATIENT_PostalCode]
		,[CRS].[SPATIENT].[POWLocationIEN] AS [SPATIENT_POWLocationIEN]
		,[CRS].[SPATIENT].[PreferredInstitutionIEN] AS [SPATIENT_PreferredInstitutionIEN]
		,[CRS].[SPATIENT].[Province] AS [SPATIENT_Province]
		,[CRS].[SPATIENT].[PseudoSSNFlag] AS [SPATIENT_PseudoSSNFlag]
		,[CRS].[SPATIENT].[PurpleHeartInstitutionIEN] AS [SPATIENT_PurpleHeartInstitutionIEN]
		,[CRS].[SPATIENT].[Race] AS [SPATIENT_Race]
		,[CRS].[SPATIENT].[RaceIEN] AS [SPATIENT_RaceIEN]
		,[CRS].[SPATIENT].[RaceSID] AS [SPATIENT_RaceSID]
		,[CRS].[SPATIENT].[Religion] AS [SPATIENT_Religion]
		,[CRS].[SPATIENT].[ReligionIEN] AS [SPATIENT_ReligionIEN]
		,[CRS].[SPATIENT].[ReligionSID] AS [SPATIENT_ReligionSID]
		,[CRS].[SPATIENT].[RoomBedIEN] AS [SPATIENT_RoomBedIEN]
		,[CRS].[SPATIENT].[ScrSSN] AS [SPATIENT_ScrSSN]
		,[CRS].[SPATIENT].[SensitiveFlag] AS [SPATIENT_SensitiveFlag]
		,[CRS].[SPATIENT].[Sta3n] AS [SPATIENT_Sta3n]
		,[CRS].[SPATIENT].[State] AS [SPATIENT_State]
		,[CRS].[SPATIENT].[StateIEN] AS [SPATIENT_StateIEN]
		,[CRS].[SPATIENT].[StateSID] AS [SPATIENT_StateSID]
		,[CRS].[SPATIENT].[STD_COMBATLOCATION_ID] AS [SPATIENT_STD_COMBATLOCATION_ID]
		,[CRS].[SPATIENT].[STD_ENTHNICITY_ID] AS [SPATIENT_STD_ENTHNICITY_ID]
		,[CRS].[SPATIENT].[STD_GENDER_ID] AS [SPATIENT_STD_GENDER_ID]
		,[CRS].[SPATIENT].[STD_MARITALSTATUS_ID] AS [SPATIENT_STD_MARITALSTATUS_ID]
		,[CRS].[SPATIENT].[STD_RACE_ID] AS [SPATIENT_STD_RACE_ID]
		,[CRS].[SPATIENT].[STD_SERVICEBRANCH_ID] AS [SPATIENT_STD_SERVICEBRANCH_ID]
		,[CRS].[SPATIENT].[StdRegistryId] AS [SPATIENT_StdRegistryId]
		,[CRS].[SPATIENT].[StreetAddress1] AS [SPATIENT_StreetAddress1]
		,[CRS].[SPATIENT].[StreetAddress2] AS [SPATIENT_StreetAddress2]
		,[CRS].[SPATIENT].[StreetAddress3] AS [SPATIENT_StreetAddress3]
		,[CRS].[SPATIENT].[TemporaryAddressChangeInstitutionIEN] AS [SPATIENT_TemporaryAddressChangeInstitutionIEN]
		,[CRS].[SPATIENT].[Updatedate] AS [SPATIENT_Updatedate]
		,[CRS].[SPATIENT].[UpdatedBy] AS [SPATIENT_UpdatedBy]
		,[CRS].[SPATIENT].[VeteranFlag] AS [SPATIENT_VeteranFlag]
		,[CRS].[SPATIENT].[VistaCreateDate] AS [SPATIENT_VistaCreateDate]
		,[CRS].[SPATIENT].[VistaEditDate] AS [SPATIENT_VistaEditDate]
		,ISNULL([CRS].[SPATIENT].[Zip],[CRS].[SPATIENT].[PostalCode]) AS [SPATIENT_Zip]
		,[CRS].[SPATIENT].[Zip4] AS [SPATIENT_Zip4]
		,RIGHT(ISNULL([CRS].[SPATIENT].[PatientSSN], ''0000''), 4) AS [SPATIENT_PatientLastFour]
	FROM 
		[CRS].[PATIENT] 
			LEFT OUTER JOIN [CRS].[SPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
	WHERE [CRS].[PATIENT].[PATIENT_ID] = @PATIENT_ID;
END

' 
END
GO



/****** Object:  StoredProcedure [CRS].[usp_PATSUB_PATIENTRACE_getitemsByReferral]    Script Date: 2/5/2018 3:33:07 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATSUB_PATIENTRACE_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_PATSUB_PATIENTRACE_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_PATSUB_PATIENTRACE_getitemsByReferral]    Script Date: 2/5/2018 3:33:07 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_PATSUB_PATIENTRACE_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'


-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all PATSUB_PATIENTRACE records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_PATSUB_PATIENTRACE_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_PATSUB_PATIENTRACE_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[PATSUB_PATIENTRACE].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[PATSUB_PATIENTRACE] ON [CRS].[PATSUB_PATIENTRACE].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END
' 
END
GO


IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[CRS].[FK_STD_QUESTION_STD_SURVEY_TYPE]') AND parent_object_id = OBJECT_ID(N'[CRS].[STD_QUESTION]'))
ALTER TABLE [CRS].[STD_QUESTION] DROP CONSTRAINT [FK_STD_QUESTION_STD_SURVEY_TYPE]
GO

/****** Object:  Index [IX_FK_AUTO_STD_QUESTION_STD_SURVEY_TYPE_ID]    Script Date: 2/26/2018 10:26:23 AM ******/
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[CRS].[STD_QUESTION]') AND name = N'IX_FK_AUTO_STD_QUESTION_STD_SURVEY_TYPE_ID')
DROP INDEX [IX_FK_AUTO_STD_QUESTION_STD_SURVEY_TYPE_ID] ON [CRS].[STD_QUESTION]
GO

/****** Object:  Table [CRS].[STD_QUESTION_TYPE]    Script Date: 2/26/2018 10:26:23 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[STD_QUESTION_TYPE]') AND type in (N'U'))
DROP TABLE [CRS].[STD_QUESTION_TYPE]
GO


/****** Object:  Table [CRS].[STD_QUESTION_TYPE]    Script Date: 2/26/2018 10:26:23 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[STD_QUESTION_TYPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [CRS].[STD_QUESTION_TYPE](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[STD_QUESTION_TYPE_ID] [int] NOT NULL,
	[QUESTION_TYPE] [varchar](50) NOT NULL,
 CONSTRAINT [PK_STD_QUESTION_TYPE] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO

SET ANSI_PADDING OFF
GO


SET IDENTITY_INSERT [CRS].[STD_QUESTION_TYPE] ON 
GO
INSERT [CRS].[STD_QUESTION_TYPE] ([ID], [STD_QUESTION_TYPE_ID], [QUESTION_TYPE]) VALUES (1, 1, N'Free Text')
GO
INSERT [CRS].[STD_QUESTION_TYPE] ([ID], [STD_QUESTION_TYPE_ID], [QUESTION_TYPE]) VALUES (2, 2, N'Multiple Choice')
GO
INSERT [CRS].[STD_QUESTION_TYPE] ([ID], [STD_QUESTION_TYPE_ID], [QUESTION_TYPE]) VALUES (3, 3, N'Scale')
GO
INSERT [CRS].[STD_QUESTION_TYPE] ([ID], [STD_QUESTION_TYPE_ID], [QUESTION_TYPE]) VALUES (4, 4, N'Description')
GO
INSERT [CRS].[STD_QUESTION_TYPE] ([ID], [STD_QUESTION_TYPE_ID], [QUESTION_TYPE]) VALUES (5, 5, N'Calculation')
GO
SET IDENTITY_INSERT [CRS].[STD_QUESTION_TYPE] OFF
GO



/****** Object:  Table [CRS].[STD_QUESTION]    Script Date: 2/26/2018 10:26:23 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF COL_LENGTH('[CRS].[STD_QUESTION]', 'STD_QUESTION_TYPE_ID') IS NULL
BEGIN
    ALTER TABLE [CRS].[STD_QUESTION] ADD [STD_QUESTION_TYPE_ID] int NULL
	PRINT '[CRS].[STD_QUESTION].STD_QUESTION_TYPE_ID column added.'
END
IF COL_LENGTH('[CRS].[STD_QUESTION]', 'UNIT_HINT') IS NULL
BEGIN
    ALTER TABLE [CRS].[STD_QUESTION] ADD [UNIT_HINT] varchar(100) NULL
	PRINT '[CRS].[STD_QUESTION].[UNIT_HINT] column added.'
END
IF COL_LENGTH('[CRS].[STD_QUESTION]', 'EXTERNAL_DATA_ID') IS NULL
BEGIN
    ALTER TABLE [CRS].[STD_QUESTION] ADD [EXTERNAL_DATA_ID] int NULL
	PRINT '[CRS].[STD_QUESTION].[EXTERNAL_DATA_ID] column added.'
END
GO

SET ANSI_PADDING OFF
GO



/****** Object:  Index [IX_FK_AUTO_STD_QUESTION_STD_SURVEY_TYPE_ID]    Script Date: 2/26/2018 10:26:23 AM ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[CRS].[STD_QUESTION]') AND name = N'IX_FK_AUTO_STD_QUESTION_STD_SURVEY_TYPE_ID')
CREATE NONCLUSTERED INDEX [IX_FK_AUTO_STD_QUESTION_STD_SURVEY_TYPE_ID] ON [CRS].[STD_QUESTION]
(
	[STD_SURVEY_TYPE_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[CRS].[FK_STD_QUESTION_STD_SURVEY_TYPE]') AND parent_object_id = OBJECT_ID(N'[CRS].[STD_QUESTION]'))
ALTER TABLE [CRS].[STD_QUESTION]  WITH CHECK ADD  CONSTRAINT [FK_STD_QUESTION_STD_SURVEY_TYPE] FOREIGN KEY([STD_SURVEY_TYPE_ID])
REFERENCES [CRS].[STD_SURVEY_TYPE] ([ID])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[CRS].[FK_STD_QUESTION_STD_SURVEY_TYPE]') AND parent_object_id = OBJECT_ID(N'[CRS].[STD_QUESTION]'))
ALTER TABLE [CRS].[STD_QUESTION] CHECK CONSTRAINT [FK_STD_QUESTION_STD_SURVEY_TYPE]
GO



/****** Object:  StoredProcedure [CRS].[usp_STD_QUESTION_save]    Script Date: 2/26/2018 10:26:43 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_QUESTION_save]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_STD_QUESTION_save]
GO

/****** Object:  StoredProcedure [CRS].[usp_STD_QUESTION_getitemsBySurvey]    Script Date: 2/26/2018 10:26:43 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_QUESTION_getitemsBySurvey]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_STD_QUESTION_getitemsBySurvey]
GO

/****** Object:  StoredProcedure [CRS].[usp_STD_QUESTION_getitemsBySurvey]    Script Date: 2/26/2018 10:26:43 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_QUESTION_getitemsBySurvey]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'







-- =============================================
-- Author:        
-- Create date:   12/15/2015
-- Description:   Get all records by Survey
-- =============================================
CREATE PROCEDURE [CRS].[usp_STD_QUESTION_getitemsBySurvey] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @STD_SURVEY_TYPE_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_STD_QUESTION_getitemsBySurvey'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT STD_QUESTION.*, STD_QUESTION_TYPE.QUESTION_TYPE AS QUESTION_TYPE FROM [CRS].[STD_QUESTION] LEFT OUTER JOIN [CRS].[STD_QUESTION_TYPE] ON STD_QUESTION.STD_QUESTION_TYPE_ID = STD_QUESTION_TYPE.STD_QUESTION_TYPE_ID WHERE [INACTIVE_FLAG] = 0 AND [STD_SURVEY_TYPE_ID] = @STD_SURVEY_TYPE_ID;
END









' 
END
GO

/****** Object:  StoredProcedure [CRS].[usp_STD_QUESTION_save]    Script Date: 2/26/2018 10:26:43 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_QUESTION_save]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'







-- =============================================
-- Author:        
-- Create date:   12/15/2015
-- Description:   Save/Update a record
-- =============================================
CREATE PROCEDURE [CRS].[usp_STD_QUESTION_save] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @CREATED datetime, @CREATEDBY varchar(30), @ID int output, @INACTIVE_DATE datetime, @INACTIVE_FLAG bit, @QUESTION_NUMBER varchar(50), @QUESTION_TEXT varchar(950), @SORT_ORDER int, @STD_SURVEY_TYPE_ID int, @UPDATED datetime, @UPDATEDBY varchar(30), @STD_QUESTION_TYPE_ID int, @UNIT_HINT varchar(100), @EXTERNAL_DATA_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUserRole](@CURRENT_USER, @CURRENT_REGISTRY_ID, ''CRSADMIN,REGADMIN'') = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_STD_QUESTION_save'', @ErrorMsg, ''User is not part of an Admin Role'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

    IF (EXISTS(SELECT [ID] FROM [CRS].[STD_QUESTION] WHERE [ID] <> @ID AND ([STD_SURVEY_TYPE_ID] = @STD_SURVEY_TYPE_ID AND [QUESTION_NUMBER] = @QUESTION_NUMBER AND [QUESTION_TEXT] = @QUESTION_TEXT AND [INACTIVE_FLAG] = 0)))
    BEGIN
		SET @ErrorMsg = ''The Survey Field you are saving already exists'';
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
    END

	DECLARE @PreviousSortOrder int;

	IF ISNULL(@ID,0) = 0
		BEGIN
			SET @PreviousSortOrder = null;
			-- if insert then set CREATED to current date time
			SET @CREATED = GetDate();
			-- if insert then set UPDATED to current date time
			SET @UPDATED = GetDate();
			INSERT INTO [CRS].[STD_QUESTION] ([CREATED], [CREATEDBY], [INACTIVE_DATE], [INACTIVE_FLAG], [QUESTION_NUMBER], [QUESTION_TEXT], [SORT_ORDER], [STD_SURVEY_TYPE_ID], [UPDATED], [UPDATEDBY], [STD_QUESTION_TYPE_ID], [UNIT_HINT], [EXTERNAL_DATA_ID])
			VALUES (@CREATED, @CREATEDBY, @INACTIVE_DATE, @INACTIVE_FLAG, @QUESTION_NUMBER, @QUESTION_TEXT, @SORT_ORDER, @STD_SURVEY_TYPE_ID, @UPDATED, @UPDATEDBY, @STD_QUESTION_TYPE_ID, @UNIT_HINT, @EXTERNAL_DATA_ID);
			SELECT @ID = SCOPE_IDENTITY();
		END
	ELSE
		BEGIN
			SELECT @PreviousSortOrder = SORT_ORDER FROM [CRS].[STD_QUESTION] WHERE [ID] = @ID;

			DECLARE @OldValues varchar(max), @NewValues varchar(max);
			SELECT @OldValues = ''<CREATED>'' + ISNULL(CAST([CREATED] AS varchar), '''') + ''</CREATED><CREATEDBY>'' + ISNULL(CAST([CREATEDBY] AS varchar), '''') + ''</CREATEDBY><ID>'' + ISNULL(CAST([ID] AS varchar), '''') + ''</ID><INACTIVE_DATE>'' + ISNULL(CAST([INACTIVE_DATE] AS varchar), '''') + ''</INACTIVE_DATE><INACTIVE_FLAG>'' + ISNULL(CAST([INACTIVE_FLAG] AS varchar), '''') + ''</INACTIVE_FLAG><QUESTION_NUMBER>'' + ISNULL(CAST([QUESTION_NUMBER] AS varchar), '''') + ''</QUESTION_NUMBER><QUESTION_TEXT>'' + ISNULL(CAST([QUESTION_TEXT] AS varchar), '''') + ''</QUESTION_TEXT><SORT_ORDER>'' + ISNULL(CAST([SORT_ORDER] AS varchar), '''') + ''</SORT_ORDER><STD_SURVEY_TYPE_ID>'' + ISNULL(CAST([STD_SURVEY_TYPE_ID] AS varchar), '''') + ''</STD_SURVEY_TYPE_ID><UPDATED>'' + ISNULL(CAST([UPDATED] AS varchar), '''') + ''</UPDATED><UPDATEDBY>'' + ISNULL(CAST([UPDATEDBY] AS varchar), '''') + ''</UPDATEDBY>'' FROM [CRS].[STD_QUESTION] WHERE [ID] = @ID;
			SELECT @NewValues = ''<CREATED>'' + ISNULL(CAST(@CREATED AS varchar), '''') + ''</CREATED><CREATEDBY>'' + ISNULL(CAST(@CREATEDBY AS varchar), '''') + ''</CREATEDBY><ID>'' + ISNULL(CAST(@ID AS varchar), '''') + ''</ID><INACTIVE_DATE>'' + ISNULL(CAST(@INACTIVE_DATE AS varchar), '''') + ''</INACTIVE_DATE><INACTIVE_FLAG>'' + ISNULL(CAST(@INACTIVE_FLAG AS varchar), '''') + ''</INACTIVE_FLAG><QUESTION_NUMBER>'' + ISNULL(CAST(@QUESTION_NUMBER AS varchar), '''') + ''</QUESTION_NUMBER><QUESTION_TEXT>'' + ISNULL(CAST(@QUESTION_TEXT AS varchar), '''') + ''</QUESTION_TEXT><SORT_ORDER>'' + ISNULL(CAST(@SORT_ORDER AS varchar), '''') + ''</SORT_ORDER><STD_SURVEY_TYPE_ID>'' + ISNULL(CAST(@STD_SURVEY_TYPE_ID AS varchar), '''') + ''</STD_SURVEY_TYPE_ID><UPDATED>'' + ISNULL(CAST(@UPDATED AS varchar), '''') + ''</UPDATED><UPDATEDBY>'' + ISNULL(CAST(@UPDATEDBY AS varchar), '''') + ''</UPDATEDBY>'';
			SELECT @ErrorMsg = ''[CRS].[STD_QUESTION] values have been updated (Old Values:'' + @OldValues + '') to (New Values:'' + @NewValues + '') by ('' + @CURRENT_USER + '')'';
			EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_STD_QUESTION_save'', @ErrorMsg, NULL, @CURRENT_USER;

			-- if update then set DateModified to current date time
			SET @UPDATED = GetDate();
			UPDATE [CRS].[STD_QUESTION] 
			SET
				[INACTIVE_DATE] = @INACTIVE_DATE
				, [INACTIVE_FLAG] = @INACTIVE_FLAG
				, [QUESTION_NUMBER] = @QUESTION_NUMBER
				, [QUESTION_TEXT] = @QUESTION_TEXT
				, [SORT_ORDER] = @SORT_ORDER
				, [STD_SURVEY_TYPE_ID] = @STD_SURVEY_TYPE_ID
				, [UPDATED] = @UPDATED
				, [UPDATEDBY] = @UPDATEDBY
				, [STD_QUESTION_TYPE_ID] = @STD_QUESTION_TYPE_ID
				, [UNIT_HINT] = @UNIT_HINT
				, [EXTERNAL_DATA_ID] = @EXTERNAL_DATA_ID
			WHERE
				[ID] = @ID;
		END

		--Increment all necessary sort order values
		IF (EXISTS(SELECT [ID] FROM [CRS].[STD_QUESTION] WHERE [STD_SURVEY_TYPE_ID] = @STD_SURVEY_TYPE_ID AND ID <> @ID AND SORT_ORDER = @SORT_ORDER AND INACTIVE_FLAG = 0))
				BEGIN
				IF @PreviousSortOrder IS NULL BEGIN
					UPDATE [CRS].[STD_QUESTION] SET SORT_ORDER = SORT_ORDER + 1 WHERE [STD_SURVEY_TYPE_ID] = @STD_SURVEY_TYPE_ID AND ID <> @ID AND SORT_ORDER >= @SORT_ORDER AND INACTIVE_FLAG = 0
				END ELSE BEGIN
					IF @PreviousSortOrder > @SORT_ORDER BEGIN
						UPDATE [CRS].[STD_QUESTION] SET SORT_ORDER = SORT_ORDER + 1 WHERE [STD_SURVEY_TYPE_ID] = @STD_SURVEY_TYPE_ID AND ID <> @ID AND SORT_ORDER >= @SORT_ORDER AND SORT_ORDER <= @PreviousSortOrder AND INACTIVE_FLAG = 0
					END ELSE BEGIN
						UPDATE [CRS].[STD_QUESTION] SET SORT_ORDER = SORT_ORDER - 1 WHERE [STD_SURVEY_TYPE_ID] = @STD_SURVEY_TYPE_ID AND ID <> @ID AND SORT_ORDER >= @PreviousSortOrder AND SORT_ORDER <= @SORT_ORDER AND INACTIVE_FLAG = 0
					END
				END
		END
END
' 
END
GO




/****** Object:  StoredProcedure [CRS].[usp_STD_WKFACTIVITYSTS_getitemByCode]    Script Date: 3/1/2018 9:24:59 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_WKFACTIVITYSTS_getitemByCode]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_STD_WKFACTIVITYSTS_getitemByCode]
GO

/****** Object:  StoredProcedure [CRS].[usp_STD_WKFACTIVITYSTS_getitemByCode]    Script Date: 3/1/2018 9:24:59 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_WKFACTIVITYSTS_getitemByCode]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/29/2015
-- Description:   Get record by ID
-- =============================================
CREATE PROCEDURE [CRS].[usp_STD_WKFACTIVITYSTS_getitemByCode] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @CODE varchar(50))
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_STD_WKFACTIVITYSTS_getitemByCode'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	--GET ACTIVITY STATUS ID
	IF EXISTS(SELECT [ID] FROM [CRS].[STD_WKFACTIVITYSTS] WHERE [STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID AND [CODE] = @CODE)
		SELECT * FROM [CRS].[STD_WKFACTIVITYSTS] WHERE [STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID AND [CODE] = @CODE;
	ELSE
		SELECT [CRS].[STD_WKFACTIVITYSTS].* FROM [CRS].[STD_WKFACTIVITYSTS] 
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [STD_REGISTRY_ID] AND [CRS].[STD_REGISTRY].[CODE] = ''CRS''
		WHERE [CRS].[STD_WKFACTIVITYSTS].[CODE] = @CODE;
END

' 
END
GO


/****** Object:  StoredProcedure [CRS].[usp_STD_WKFCASESTS_getitemByCode]    Script Date: 3/1/2018 9:26:14 AM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_WKFCASESTS_getitemByCode]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_STD_WKFCASESTS_getitemByCode]
GO

/****** Object:  StoredProcedure [CRS].[usp_STD_WKFCASESTS_getitemByCode]    Script Date: 3/1/2018 9:26:14 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_STD_WKFCASESTS_getitemByCode]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/29/2015
-- Description:   Get record by ID
-- =============================================
CREATE PROCEDURE [CRS].[usp_STD_WKFCASESTS_getitemByCode] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @CODE varchar(50))
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_STD_WKFCASESTS_getitemByCode'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	--GET CASE STATUS ID
	IF EXISTS(SELECT [ID] FROM [CRS].[STD_WKFCASESTS] WHERE [STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID AND [CODE] = @CODE)
		SELECT * FROM [CRS].[STD_WKFCASESTS] WHERE [STD_REGISTRY_ID] = @CURRENT_REGISTRY_ID AND [CODE] = @CODE;
	ELSE
		SELECT [CRS].[STD_WKFCASESTS].* FROM [CRS].[STD_WKFCASESTS] 
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [STD_REGISTRY_ID] AND [CRS].[STD_REGISTRY].[CODE] = ''CRS''
		WHERE [CRS].[STD_WKFCASESTS].[CODE] = @CODE;
END

' 
END
GO


/****** Object:  StoredProcedure [CRS].[usp_VITALSIGN_getitemsByReferral]    Script Date: 3/6/2018 12:47:33 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_VITALSIGN_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_VITALSIGN_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_VITALSIGN_getitemsByReferral]    Script Date: 3/6/2018 12:47:33 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_VITALSIGN_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all VITALSIGN records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_VITALSIGN_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_VITALSIGN_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[VITALSIGN].[VitalSignSID]
		,[CRS].[VITALSIGN].[VitalSignIEN]
		,[CRS].[VITALSIGN].[Sta3n]
		,[CRS].[VITALSIGN].[VitalSignTakenDateTime]
		,ISNULL([CRS].[VITALSIGN].[VitalSignTakenDateSID], 0) as [VitalSignTakenDateSID]
		,ISNULL([CRS].[VITALSIGN].[VitalSignTakenTimeSID], 0) as [VitalSignTakenTimeSID]
		,[CRS].[VITALSIGN].[PatientSID]
		,[CRS].[VITALSIGN].[VitalTypeIEN]
		,[CRS].[VITALSIGN].[VitalTypeSID]
		,[CRS].[VITALSIGN].[VitalType]
		,[CRS].[VITALSIGN].[Result]
		,[CRS].[VITALSIGN].[ResultNumeric]
		,[CRS].[VITALSIGN].[Systolic]
		,[CRS].[VITALSIGN].[Diastolic]
		,[CRS].[VITALSIGN].[SupplementalO2]
		,[CRS].[VITALSIGN].[LocationIEN]
		,[CRS].[VITALSIGN].[LocationSID]
		,[CRS].[VITALSIGN].[Location]
		,[CRS].[VITALSIGN].[DivisionSID]
		,[CRS].[VITALSIGN].[Sta6a]
		,[CRS].[VITALSIGN].[StaffIEN]
		,[CRS].[VITALSIGN].[StaffSID]
		,[CRS].[VITALSIGN].[VitalSignEnteredDateTime]
		,[CRS].[VITALSIGN].[EnteredInErrorFlag]
		,[CRS].[VITALSIGN].[ErrorEnteredByIEN]
		,[CRS].[VITALSIGN].[ErrorEnteredBySID]
		,[CRS].[VITALSIGN].[ETLBatchID]
		,[CRS].[VITALSIGN].[OpCode]
		,[CRS].[VITALSIGN].[VistaCreateDate]
		,[CRS].[VITALSIGN].[VistaEditDate]
		,[CRS].[VITALSIGN].[StdRegistryId]
		,[CRS].[VITALSIGN].[CreatedBy]
		,[CRS].[VITALSIGN].[UpdatedBy]
		,[CRS].[VITALSIGN].[Created]
		,[CRS].[VITALSIGN].[Updated]
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[VITALSIGN] ON [CRS].[VITALSIGN].[PatientSID] = [CRS].[sPATIENT].[PatientSID]
	WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END
' 
END
GO


/****** Object:  StoredProcedure [CRS].[usp_REFERRAL_getitemByPatientIcn]    Script Date: 3/26/2018 5:03:16 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_REFERRAL_getitemByPatientIcn]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_REFERRAL_getitemByPatientIcn]
GO

/****** Object:  StoredProcedure [CRS].[usp_REFERRAL_getitemByPatientIcn]    Script Date: 3/26/2018 5:03:16 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [CRS].[usp_REFERRAL_getitemByPatientIcn] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @PatientICN varchar(50))
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = 'User is not authorized to perform this action.';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, 'CRS.usp_REFERRAL_getitem', @ErrorMsg, 'User is not part of this Registry', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT TOP 1
		REFERRAL.* 
	FROM
		[CRS].[REFERRAL] INNER JOIN
		[CRS].[PATIENT] ON PATIENT.PATIENT_ID = REFERRAL.PATIENT_ID
	WHERE
		REFERRAL.STD_REGISTRY_ID = @CURRENT_REGISTRY_ID AND PATIENT.PatientICN = @PatientICN
END

GO


/****** Object:  StoredProcedure [CRS].[usp_LabScreening_getitemsByReferral]    Script Date: 3/12/2018 3:05:25 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_LabScreening_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_LabScreening_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_LabScreening_getitemsByReferral]    Script Date: 3/12/2018 3:05:25 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_LabScreening_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'



-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all Lab Screening records by Referral
-- =============================================
CREATE PROCEDURE [CRS].[usp_LabScreening_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_LabScreening_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT 
		s.Gender
		,s.DateOfBirth
		,((CONVERT(int,CONVERT(char(8),CURRENT_TIMESTAMP,112))-CONVERT(char(8),s.DateOfBirth,112))/10000) as [Age]
		,ISNULL(pr.Race, ''N/A'') as [Race]
		,lab.LABCHEMSPECIMENDATETIME
		,lab.LABCHEMCOMPLETEDATETIME
		,lc.LOINC
		,lc.Component
		,lc.Property
		,lc.MethodType
		,lc.Units
		,lab.LABCHEMRESULTVALUE
		,lab.ABNORMAL
		,lab.REFHIGH
		,lab.REFLOW 
	FROM 
		CRS.STD_LOINC_CODE lc
			inner join CRS.CHEM_LABCHEM lab on lc.loincsid=lab.loincsid
			inner join CRS.SPATIENT s on lab.patientsid=s.patientsid
			inner join CRS.PATIENT p on s.patienticn=p.patienticn
			inner join CRS.REFERRAL r on p.patient_id=r.patient_id
			left outer join CRS.PATSUB_PATIENTRACE pr on pr.PatientSID=s.PatientSID
	WHERE r.REFERRAL_ID = @REFERRAL_ID
		and lc.LOINC in (''15045-8'',''21232-4'',''2160-0'') 
	ORDER BY lab.LABCHEMSPECIMENDATETIME DESC

END

' 
END
GO

if not exists(select * from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Lab Screening')
begin
	insert into CRS.STD_REGISTRY_CORE_TYPES (TABLE_NAME,CODE,NAME,DESCRIPTION_TEXT,CREATEDBY,UPDATEDBY,CREATED,UPDATED,DEFAULT_FLAG) 
	values ('CHEM_LABCHEM and STD_LOINC_CODE','Lab Screening','Lab Screening','Lab Screening','InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,1);
end
go

if exists(select ID from CRS.STD_REGISTRY where CODE='KDR')
begin
	if not exists(select * from CRS.REGISTRY_CORE_DATA where STD_REGISTRY_ID=(select ID from CRS.STD_REGISTRY where CODE='KDR') and CORE_TYPE_ID=(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Lab Screening'))
	begin
		insert into CRS.REGISTRY_CORE_DATA (STD_REGISTRY_ID,CORE_TYPE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG) 
		values ((select ID from CRS.STD_REGISTRY where CODE='KDR'),(select CORE_TYPE_ID from CRS.STD_REGISTRY_CORE_TYPES where DESCRIPTION_TEXT='Lab Screening'),'InsertScript','InsertScript',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,1);
	end
end
go

/****** Object:  StoredProcedure [CRS].[usp_TRACER_getitemsByReferral]    Script Date: 4/16/2018 2:38:42 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_TRACER_getitemsByReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [CRS].[usp_TRACER_getitemsByReferral]
GO

/****** Object:  StoredProcedure [CRS].[usp_TRACER_getitemsByReferral]    Script Date: 4/16/2018 2:38:42 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CRS].[usp_TRACER_getitemsByReferral]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:        
-- Create date:   12/6/2017
-- Description:   Get all RADIOLOGYEXAM records by Referral
-- =============================================
create PROCEDURE [CRS].[usp_TRACER_getitemsByReferral] (@CURRENT_USER varchar(30), @CURRENT_REGISTRY_ID int, @REFERRAL_ID int)
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @ErrorMsg varchar(max);

	IF ([CRS].[ValidateUser](@CURRENT_USER, @CURRENT_REGISTRY_ID) = 0)
	BEGIN
		SET @ErrorMsg = ''User is not authorized to perform this action.'';
		EXEC [CRS].[InsDBLog] @CURRENT_REGISTRY_ID, 0, ''CRS.usp_RADIOLOGYEXAM_getitemsByReferral'', @ErrorMsg, ''User is not part of this Registry'', @CURRENT_USER
		SELECT @ErrorMsg as [ErrorMsg];
		RETURN
	END

	SELECT
		[CRS].[TRANSPLANTREGISTRY_TRACER].*
	FROM 
		[CRS].[REFERRAL]
			INNER JOIN [CRS].[STD_REGISTRY] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID]
			INNER JOIN [CRS].[PATIENT] ON [CRS].[PATIENT].[Patient_ID] = [CRS].[REFERRAL].[PATIENT_ID]
			INNER JOIN [CRS].[sPATIENT] ON [CRS].[sPATIENT].[PatientICN] = [CRS].[PATIENT].[PatientICN]
			INNER JOIN [CRS].[TRANSPLANTREGISTRY_TRACER] ON [CRS].[TRANSPLANTREGISTRY_TRACER].PatientICN = [CRS].[sPATIENT].PatientICN	
			WHERE 
		[CRS].[REFERRAL].[REFERRAL_ID] = @REFERRAL_ID
		AND [CRS].[STD_REGISTRY].[INACTIVE_FLAG] = 0;
END
' 
END
GO


IF NOT EXISTS (select * from [CRS].[STD_REGISTRY_CORE_TYPES] where [DESCRIPTION_TEXT]='Tracer')
BEGIN
	insert into [CRS].[STD_REGISTRY_CORE_TYPES] (TABLE_NAME,CODE,NAME,DESCRIPTION_TEXT,COMMENT,CREATEDBY,UPDATEDBY,CREATED,UPDATED,DEFAULT_FLAG) VALUES ('CRS.TRANSPLANTREGISTRY_TRACER','Tracer','Tracer','Tracer',NULL,'InsertScript','InsertScript',GETDATE(),GETDATE(),1);

	insert into [CRS].[REGISTRY_CORE_DATA] (STD_REGISTRY_ID,CORE_TYPE_ID,VALUE,COMMENT,CREATEDBY,UPDATEDBY,CREATED,UPDATED,SELECTED_FLAG)
	select distinct STD_REGISTRY_ID,(select top(1) CORE_TYPE_ID from [CRS].[CRS].[STD_REGISTRY_CORE_TYPES] where TABLE_NAME = 'CRS.TRANSPLANTREGISTRY_TRACER'),NULL,NULL,'InsertScript','InsertScript',GETDATE(),GETDATE(),0 from [CRS].[REGISTRY_CORE_DATA];
END
GO